/* 
main.c
2003-2004 All Rights Reserved to Didier STRAUS
Calendrier X  v1.3.3
http://www.Software-DS.com
http://perso.wanadoo.fr/timan/timan/index.html
e-mail: Software-DS@wanadoo.fr
*/

#include <Carbon/Carbon.h>
#include "main.h"

#define	largeur 17
#define rMenuBar 128

typedef struct dat{
    int jour;
    int mois;
    int annee;
} date;

/* prototypes */

void Initialize(void);
void EventLoop(void);
void MakeWindow(int Lang);
void MakeMenu(void);
void DoEvent(EventRecord *event);
void DoMenuCommand(long menuResult);
void DoAboutBox(void);
static OSErr QuitAppleEventHandler(const AppleEvent *appleEvt, AppleEvent* reply, UInt32 refcon);
void affiche_nombre(int a,int b,int val,int p,int q);
OSErr Pict2File(PicHandle thePicture);
Boolean doTabEditClock (void);

/* variables globales */

Boolean	  gQuitFlag;
WindowRef gMainWindow;
SInt16	  year;
WindowPtr theWindow;
PicHandle thePic;
int dur[13]={0,31,28,31,30,31,30,31,31,30,31,30,31};
date db,df,dd;
long int nbj,nbjd,nbjf,k,jour;
int signe,i,j,w,m,a,mois,x=0,y=0,marge;
Rect drawingRect,pictureRect;

int main(int argc,char *argv[]){
    Initialize();
//  MakeWindow(1); /* Ask for a Calendar in English at start up */
    MakeMenu();
    EventLoop();

    return 0;
}

void Initialize(){
    OSErr err;
        
    InitCursor();
    err = AEInstallEventHandler( kCoreEventClass, kAEQuitApplication, NewAEEventHandlerUPP((AEEventHandlerProcPtr)QuitAppleEventHandler), 0, false );
    if (err != noErr)
        ExitToShell();
}

static OSErr QuitAppleEventHandler( const AppleEvent *appleEvt, AppleEvent* reply, UInt32 refcon ){
    gQuitFlag = true;
    
    return noErr;
}

void EventLoop(){
    Boolean gotEvent;
    EventRecord	event;
        
    gQuitFlag = false;
    do {
        gotEvent = WaitNextEvent(everyEvent, &event, kSleepTime, nil);
        if (gotEvent)
            DoEvent(&event);
    } while (!gQuitFlag);
    
    ExitToShell();					
}

void MakeWindow(int Lang){
    Boolean ret;
    ret=doTabEditClock(); /* Saisie de la date */
    
    if (ret==false)
        return;

    if (!(theWindow = GetNewCWindow(300,NULL,(WindowPtr) -1))){
        SysBeep(5);
        ExitToShell();
    }
    SetPortWindowPort(theWindow);

    ShowSheetWindow(theWindow, gMainWindow);
    GetPortBounds(GetWindowPort(theWindow), &pictureRect);
    ClipRect(&pictureRect);
    
    SetRect(&drawingRect,0,0,540,360);
    thePic=OpenPicture(&drawingRect);
    EraseRect(&pictureRect);
    
    PenSize(0,0); 
    MoveTo(pictureRect.left, pictureRect.top);
    Line(0,0);
    
    PenSize(1,1);
    
    if (theWindow != nil)
        SetPortWindowPort(theWindow);
    else
        ExitToShell();		

    ForeColor(greenColor);
    MoveTo(190,16);
    switch(Lang){
        case 1:
            DrawString("\pCalendar of the year");
            break;
        case 2:
            DrawString("\pCalendrier de l'anne");
            break;
        case 3:
            DrawString("\pCalendario del ao");
            break;
        case 4:
            DrawString("\pJahreskalender");
            break;
        case 5:
            DrawString("\pCalendario dell'anno");
            break;
        case 6:
            DrawString("\pKalender van het jaar");
            break;
    }
    
    i=year;
    a=1000;
    for(j=1;j<4;j++) {
        w=i/a;
        MoveTo(325+j*8,16); /* On affiche les chiffres de l'anne, un  un */
        DrawChar(w+48);
        i=i-a*w;
        a/=10;
    }
    MoveTo(325+j*8,16); /* On affiche le dernier chiffre de l'anne */
    DrawChar(i+48);
    ForeColor(blackColor);
    TextSize(9);
    x=y=0;
    
     /* Affichage du Calendrier */

    for(m=1;m<13;m++) {  /* Dbut de la boucle pour afficher les 12 mois */
        db.jour = 1;
        mois = 1;
        db.mois = m;
        db.annee = year;
        dd.jour = db.jour;
        dd.mois = db.mois;
        dd.annee = db.annee;
        signe = -1;
        df.jour = 2;
        df.mois = 1;
        df.annee = 2000;
        jour = 1;

        if ((db.mois >= df.mois) && (db.annee >= df.annee)) {
            /* df <- db */
            db.jour = df.jour;
            db.mois = df.mois;
            db.annee = df.annee;
            /* df <- dd */
            df.jour = dd.jour;
            df.mois = dd.mois;
            df.annee = dd.annee;
            signe = 1;
        }


        if ((((db.annee%4)==0) && (db.annee%100!=0)) || ((db.annee%400)==0)) /* anne bissextile ? */
            dur[2] = 29;
        
        nbjd = dur[db.mois]-db.jour;
        for(k=(db.mois+1);k<13;k++)
            nbjd+=dur[k];
            
            if ((((db.annee%4)==0) && (db.annee%100!=0)) || ((db.annee%400)==0)) /* anne bissextile ? */
                dur[2] = 28;
            if ((((df.annee%4)==0) && (df.annee%100!=0)) || ((df.annee%400)==0)) /* anne bissextile ? */
                dur[2] = 29;
            nbjf = df.jour;
            for(k=1;k<df.mois;k++)
                nbjf = nbjf + dur[k];

            if ((((df.annee%4)==0) && (df.annee%100!=0)) || ((df.annee%400)==0)) /* anne bissextile ? */
                dur[2] = 28;
    

            nbj = nbjd+nbjf;
            for(k=1;k<(df.annee-db.annee);k++) {
                nbj+=365;
                if ((((db.annee+k)%4)==0) && ((db.annee+k)%100!=0) || (((db.annee+k)%400)==0)) /* anne bissextile ? */
                    nbj++;                
            }

            if ((db.annee-df.annee) == 0) {
                nbj-=365;
                if ((((db.annee%4)==0) && (db.annee%100!=0)) || ((db.annee%400)==0)) /* anne bissextile ? */
                    nbj--;
            }

            if ((year==2000) && (m==1)) /* bug with year2000 */
                nbj=6;
            
            while (nbj!=0) {
                nbj--;
                jour+=signe;
                if (jour == 0)
                    jour = 7;
                else if (jour == 8)
                    jour = 1;
            }
        

	/* Affichage des mois */
            
            MoveTo(x+2*largeur,35+y);
            switch(Lang){
                case 1: /* English */
                    switch (m){
                        case  1: DrawString("\p January");	break;
                        case  2: DrawString("\pFebruary");	break;
                        case  3: DrawString("\p  March");	break;
                        case  4: DrawString("\p   April");	break;
                        case  5: DrawString("\p    May");	break;
                        case  6: DrawString("\p   June");	break;
                        case  7: DrawString("\p   July");	break;
                        case  8: DrawString("\p  August");	break;
                        case  9: DrawString("\pSeptember");	break;
                        case 10: DrawString("\p October");	break;
                        case 11: DrawString("\pNovember");	break;
                        case 12: DrawString("\pDecember");	break;
                    }
                    break;
                    
                case 2: /* French */
                    switch (m){
                        case  1: DrawString("\p Janvier");	break;
                        case  2: DrawString("\p Fvrier");	break;
                        case  3: DrawString("\p   Mars");	break;
                        case  4: DrawString("\p   Avril");	break;
                        case  5: DrawString("\p    Mai");	break;
                        case  6: DrawString("\p   Juin");	break;
                        case  7: DrawString("\p  Juillet");	break;
                        case  8: DrawString("\p    Aot");	break;
                        case  9: DrawString("\pSeptembre");	break;
                        case 10: DrawString("\p Octobre");	break;
                        case 11: DrawString("\pNovembre");	break;
                        case 12: DrawString("\pDcembre");	break;
                    }
                    break;
                
                case 3: /* Spanish */
                    switch (m){
                        case  1: DrawString("\p  Enero");	break;
                        case  2: DrawString("\p Febrero");	break;
                        case  3: DrawString("\p  Marzo");	break;
                        case  4: DrawString("\p   Abril");	break;
                        case  5: DrawString("\p   Mayo");	break;
                        case  6: DrawString("\p   Junio");	break;
                        case  7: DrawString("\p   Julio");	break;
                        case  8: DrawString("\p  Agosto");	break;
                        case  9: DrawString("\pSeptiembre");	break;
                        case 10: DrawString("\p Octubre");	break;
                        case 11: DrawString("\pNoviembre");	break;
                        case 12: DrawString("\pDiciembre");	break;
                    }
                    break;

                case 4: /* German */
                    switch (m){
                        case  1: DrawString("\p Januar");	break;
                        case  2: DrawString("\p Februar");	break;
                        case  3: DrawString("\p   Marz");	break;
                        case  4: DrawString("\p   April");	break;
                        case  5: DrawString("\p   Mai");	break;
                        case  6: DrawString("\p   Juni");	break;
                        case  7: DrawString("\p   Juli");	break;
                        case  8: DrawString("\p  August");	break;
                        case  9: DrawString("\pSeptember");	break;
                        case 10: DrawString("\p Oktober");	break;
                        case 11: DrawString("\p November");	break;
                        case 12: DrawString("\p Dezember");	break;
                    }
                    break;
         
                case 5: /* Italian */
                    switch (m){
                        case  1: DrawString("\p Gennaio");	break;
                        case  2: DrawString("\p Febbraio");	break;
                        case  3: DrawString("\p   Marzo");	break;
                        case  4: DrawString("\p  Aprile");	break;
                        case  5: DrawString("\p  Maggio");	break;
                        case  6: DrawString("\p   Giugno");	break;
                        case  7: DrawString("\p   Luglio");	break;
                        case  8: DrawString("\p   Agosto");	break;
                        case  9: DrawString("\pSettembre");	break;
                        case 10: DrawString("\p Ottobre");	break;
                        case 11: DrawString("\p Novembre");	break;
                        case 12: DrawString("\p Dicembre");	break;
                    }
                    break;
                
                case 6: /* Dutchman */
                    switch (m){
                        case  1: DrawString("\p Januari");	break;
                        case  2: DrawString("\p Februari");	break;
                        case  3: DrawString("\p   Maart");	break;
                        case  4: DrawString("\p   April");	break;
                        case  5: DrawString("\p    Mei");	break;
                        case  6: DrawString("\p   Juni");	break;
                        case  7: DrawString("\p   Juli");	break;
                        case  8: DrawString("\p Augustus");	break;
                        case  9: DrawString("\pSeptember");	break;
                        case 10: DrawString("\p Oktober");	break;
                        case 11: DrawString("\p November");	break;
                        case 12: DrawString("\p December");	break;
                    }
                    break;
            }

            ForeColor(blackColor);
            MoveTo(10+x,50+y);
            if ((Lang==1) || (Lang==4))
                DrawChar('S');
            else if ((Lang==2) || (Lang==3) || (Lang==5))
                DrawChar('D');
            else if (Lang==6)
                DrawChar('Z');
            
            MoveTo(10+x+largeur,50+y);
            if ((Lang==1) || (Lang==4) || (Lang==6))
                DrawChar('M');
            else if ((Lang==2) || (Lang==3) || (Lang==5))
                DrawChar('L');
            
            MoveTo(10+x+largeur*2,50+y);
            if (Lang==1)
                DrawChar('T');
            else if ((Lang==2) || (Lang==3) || (Lang==5))
                DrawChar('M');
            else if ((Lang==4) || (Lang==6))
                DrawChar('D');
            
            MoveTo(10+x+largeur*3,50+y);
            if ((Lang==1) || (Lang==6))
                DrawChar('W');
            else if ((Lang==2) || (Lang==3) || (Lang==4) || (Lang==5))
                DrawChar('M');
            
            MoveTo(10+x+largeur*4,50+y);
            if (Lang==1)
                DrawChar('T');
            else if ((Lang==2) || (Lang==3))
                DrawChar('J');
            else if ((Lang==4) || (Lang==6))
                DrawChar('D');
            else if (Lang==5)
                DrawChar('G');
            
            MoveTo(10+x+largeur*5,50+y);
            if ((Lang==1) || (Lang==4))
                DrawChar('F');
            else if ((Lang==2) || (Lang==3) || (Lang==5) || (Lang==6))
                DrawChar('V');
            
            MoveTo(10+x+largeur*6,50+y);
            if (Lang==6)
                DrawChar('Z');
            else
                DrawChar('S');
            
            marge=0;
            for(j=1;j<jour;j++) {
                marge+=1;
            }
            if ((((dd.annee%4)==0) && (dd.annee%100!=0)) || ((dd.annee%400)==0)) { /* anne bissextile ? */
                dur[2] = 29;
            }

            w=0;
            for(i=j;i<dur[dd.mois]+jour;i++) {
                affiche_nombre(marge,w,i-jour+1,10+x,60+y);
                marge++;
                if ((i%7)==0) {
                    w++;
                    marge=0;
                }
            }

            x+=8*largeur;
            if ((m%4)==0) {
                y+=9*11;
                x=0;
            }

	} /* Fin du 'For' */

	MoveTo(75,355);
	DrawString("\p2003-2004 All Rights Reserved to Didier STRAUS   http://www.Software-DS.com");

	ClosePicture();  /* Tout le dessin du calendrier est mmoris dans 'thePic' */
	DrawPicture(thePic, &drawingRect); /* On dessine l'image et donc le calendrier. */
        QDFlushPortBuffer( GetQDGlobalsThePort(), NULL ); /* Pour que le Mac affiche les graphismes */

}

void MakeMenu() {
    Handle	menuBar;
    MenuRef	menu;
    long	response;
    OSErr	err;
    
    menuBar = GetNewMBar(rMenuBar);
    if (menuBar != nil) {
        SetMenuBar(menuBar);
        err = Gestalt(gestaltMenuMgrAttr, &response);
	if ((err == noErr) && (response & gestaltMenuMgrAquaLayoutMask)) {
            menu = GetMenuHandle(mFile);
            DeleteMenuItem(menu, iQuit);
            DeleteMenuItem(menu, iQuitSeparator);
    }
                
	menu = GetMenu(mLanguage);
	if(menu != NULL)
            InsertMenu(menu,hierMenu);
	else
            ExitToShell();
        
        DrawMenuBar();
    }
    else
    	ExitToShell();
}

void DoEvent(EventRecord *event){
    short	part;
    Boolean	hit;
    char	key;
    Rect	tempRect;
    WindowRef	whichWindow;
        
    switch (event->what)  {
        case mouseDown:
            part = FindWindow(event->where, &whichWindow);
            switch (part) {
                case inMenuBar:
                    DoMenuCommand(MenuSelect(event->where));
                    break;
                    
                case inSysWindow:
                    break;
                
                case inContent:
                    if (whichWindow != FrontWindow()) 
                        SelectWindow(whichWindow);
                    break;
                
                case inDrag:
                    GetRegionBounds(GetGrayRgn(), &tempRect);
                    DragWindow(whichWindow, event->where, &tempRect);
                    break;
                    
                case inGrow:
                    break;
                    
                case inGoAway:
                    if (TrackGoAway(whichWindow, event->where))
                      DisposeWindow(whichWindow);
                    break;
                    
                case inZoomIn:
                case inZoomOut:
                    hit = TrackBox(whichWindow, event->where, part);
                    if (hit) {
                        SetPort(GetWindowPort(whichWindow));
                        EraseRect(GetWindowPortBounds(whichWindow, &tempRect));
                        ZoomWindow(whichWindow, part, true);
                        InvalWindowRect(whichWindow, GetWindowPortBounds(whichWindow, &tempRect));
                    }
                    break;
                }
                break;
		
                case keyDown:
		case autoKey:
                    key = event->message & charCodeMask;
                    if (event->modifiers & cmdKey)
                        if (event->what == keyDown)
                            DoMenuCommand(MenuKey(key));
		case activateEvt:
                    break;
                    
                case updateEvt:
                        DrawPicture(thePic, &drawingRect); /* On dessine l'image du calendrier. */
                        QDFlushPortBuffer(GetQDGlobalsThePort(), NULL);
			break;

                case kHighLevelEvent:
			AEProcessAppleEvent(event);
			break;
		
                case diskEvt:
			break;
	}
}

void DoMenuCommand(long menuResult) {
    short menuID;
    short menuItem;
    OSErr anErr;
    int language=1;
    
    menuID = HiWord(menuResult);
    menuItem = LoWord(menuResult);
	
    switch (menuID) {
        case mApple:
            switch (menuItem) {
                case iAbout:
                    DoAboutBox();
                    break;
                    
                case iQuit:
                    ExitToShell();
                    break;
				
                default:
                    break;
            }
            break;
        
        case mFile:
            if(menuItem == iSave)
                if (thePic != nil)
                    anErr=Pict2File(thePic);
            break;
        
        case mLanguage:
                switch(menuItem) {
                    case iEnglish:
                        language=1;
                        break;
                        
                    case iFrench:
                        language=2;
                        break;
                    
                    case iSpanish:
                        language=3;
                        break;
                        
                    case iGerman:
                        language=4;
                        break;
                    
                    case iItalian:
                        language=5;
                        break;
                    
                    case iDutchman:
                        language=6;
                        break;
                }
                if (theWindow != nil)
                    DisposeWindow(theWindow);
                MakeWindow(language);
                break;
    }
    HiliteMenu(0);
}

void DoAboutBox(void) {
    StandardAlert(kAlertNoteAlert, "\pCalendrier X 1.3.3    2003-2004 Didier STRAUS", "\phttp://www.Software-DS.com   Software-DS@wanadoo.fr", NULL, NULL);
}

void affiche_nombre(int a,int b,int val,int p,int q) {
    int aux;

    if (val<10) {
        val+=48;
        MoveTo(p+a*largeur,q+b*11);
        DrawChar(val);
    }
    else {
        aux=val/10;
        MoveTo(p+a*largeur-3,q+b*11); /* 1 chiffre */
        DrawChar(aux+48);
        val-=aux*10;
        MoveTo(p+a*largeur+3,q+b*11); /* 2 chiffre */
        DrawChar(val+48);
    }
}

OSErr Pict2File(PicHandle thePicture) { // Pour sauvegarder l'image du calendrier ;-)
    OSErr               anErr = noErr;
    NavReplyRecord      reply;
    NavDialogOptions    dialogOptions;
    OSType              fileTypeToSave = 'PICT';
    OSType              creatorType = '????'; // l'image s'ouvrira avec le logiciel Preview (Aperu)
    AEKeyword   	theKeyword;
    DescType    	actualType;
    Size        	actualSize;
    FSSpec      	documentFSSpec;
    long		inOutCount;
    short		refNum, count;
    unsigned char 	header[512];
    
    for (count = 0; count < 512; count++)
        header[count] = 0x00;

    anErr = NavGetDefaultDialogOptions(&dialogOptions);
    dialogOptions.dialogOptionFlags |= kNavSelectDefaultLocation;
    
    anErr = NavPutFile( nil,&reply,&dialogOptions,nil,fileTypeToSave,creatorType,nil);
    if (anErr == noErr && reply.validRecord) {
    					
    	anErr = AEGetNthPtr(&(reply.selection),1,typeFSS,&theKeyword, &actualType,
                            &documentFSSpec,sizeof(documentFSSpec),&actualSize );
      
        if (anErr == noErr) {
            anErr = FSpCreate(&documentFSSpec,creatorType,fileTypeToSave,smSystemScript);
            if (anErr == dupFNErr) {
                anErr = FSpDelete(&documentFSSpec);
                anErr = FSpCreate(&documentFSSpec,creatorType,fileTypeToSave,smSystemScript);
            }
            FSpOpenDF(&documentFSSpec,fsRdWrPerm,&refNum);
            inOutCount = 512;
            anErr = FSWrite(refNum,&inOutCount,header);
            if (anErr == noErr) {
                inOutCount = GetHandleSize((Handle)thePicture);
                anErr = FSWrite(refNum,&inOutCount,*thePicture);
            }
            FSClose(refNum);
  	  }
  	  reply.translationNeeded = false;
  	  anErr = NavCompleteSave(&reply, kNavTranslateInPlace);

 	  NavDisposeReply(&reply);
    }
    
    return 0;
}
